import pygame
import sys
import random

pygame.init()

WINDOW_SIZE = 400, 400
BLOCK_SIZE = 20
screen = pygame.display.set_mode((WINDOW_SIZE, WINDOW_SIZE))
clock = pygame.time.Clock()

snake = [(5, 5), (4, 5), (3, 5)]
snake.sort()
direction = (1, 0)

### Given Functions to Make Your Life Easy! ###
### Do not change these functions - this will cause snake to break ###

def random_pair(bottom: int, top: int): 
    """
    Returns a random X and Y coordinate when given an upper bound and a lower bound. 

    Parameters:
        bottom (int): The bottom of the range of numbers to generate from.
        top (int): The top of the range of numbers to generate from. 

    Returns:
        Two random numbers, in (x, y) format.
    """
    return (random.randint(bottom, top), random.randint(bottom, top))

def draw_item(x: int, y:int, color=(0,255,0)):
    """
    Draws on the screen at x,y coordinates and given color. 
    """
    x = x * BLOCK_SIZE
    y = y * BLOCK_SIZE
    pygame.draw.rect(screen, color, (x,y, BLOCK_SIZE, BLOCK_SIZE ))

def draw_snake():
    for segment in snake:
        draw_item(segment[0],segment[1])

### END OF GIVEN FUNCTIONS ###

def get_direction():

    LEFT = (-1,0)
    RIGHT = (1,0)
    UP = (0, -1)
    DOWN = (0,1)

    keys = pygame.key.get_pressed()
    if keys[pygame.K_UP] and direction != DOWN:
        
    elif keys[pygame.K_DOWN] and direction != UP:
        
    elif keys[pygame.K_LEFT] and direction != RIGHT:
        
    elif keys[pygame.K_RIGHT] and direction != LEFT:
        
    else:
        return direction


# Main game loop
running = True
while running:
    screen.fill((0, 0, 0))
    draw_snake()


    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False


    pygame.display.flip()
    clock.tick(10)

pygame.quit()
sys.exit()